--| +=========================================================================+
--| |                                                                         |
--| | REGION_SCAN.REGION_SCAN_INTERNAL.SCAN_SUBTYPE_INDICATION (body)         |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Region_Scan.Region_Scan_Internal)
procedure Scan_Subtype_Indication (The_Indication : in Asis.Subtype_Indication; 
				   The_Context : in out Context) is

    Cuid : constant String := 
       "Region_Scan.Region_Scan_Internal.Scan_Subtype_Indication";
    Puid : constant String := "Scan_Subtype_Indication";

    package Error renames Region_Scan_Internal.Error_Handling_Support;

begin

    if Rgn.Denotes_One_Or_More_Regions (The_Indication, 
					Region_Scan.Expand_Instantiations) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements (The_Indication, 
					   Region_Scan.Expand_Instantiations);
	    Regions : constant Rgn.Region_List := 
	       Rgn.Denoted_Regions (The_Indication, 
				    Region_Scan.Expand_Instantiations, 
				    Region_Scan.Include_Instance_Bodies);
	begin
	    Region_Scan_Internal.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Context);
	    for I in Regions'Range loop
		Region_Scan.Process_Region (Regions (I), The_Context);
	    end loop;
	end;
	return;
    end if;

    declare
	Constraint : Asis.Constraint := 
	   Asis_Td.Subtype_Constraint (The_Indication);
	Type_Mark : Asis.Expression := Asis_Td.Type_Mark (The_Indication);
    begin

	Region_Scan_Internal.Scan_Expression (Type_Mark, The_Context);

	if not Asis_E.Is_Nil (Constraint) then
	    Region_Scan_Internal.Scan_Constraint (Constraint, The_Context);
	end if;

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Indication);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Indication);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Indication);
	raise;

end Scan_Subtype_Indication;
