--| +=========================================================================+
--| |                                                                         |
--| | REGION_SCAN.REGION_SCAN_INTERNAL.SCAN_VARIANT_LIST (body)               |
--| |                                                                         |
--| | Scans a list of variants and pragmas.                                   |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Region_Scan.Region_Scan_Internal)
procedure Scan_Variant_List (The_List : in Asis.Variant_List; 
			     The_Context : in out Context) is

    Cuid : constant String := 
       "Region_Scan.Region_Scan_Internal.Scan_Variant_List";
    Puid : constant String := "Scan_Variant_List";

    package Error renames Region_Scan_Internal.Error_Handling_Support;

    The_Element : Asis.Element;

begin

    for I in The_List'Range loop
	The_Element := The_List (I);
	case Asis_E.Element_Kind (The_Element) is
	    when Asis_E.A_Variant =>
		Region_Scan_Internal.Scan_Variant (The_Element, The_Context);
	    when Asis_E.A_Pragma =>
		Region_Scan_Internal.Scan_Pragma (The_Element, The_Context);
	    when others =>
		Error.Log (Error.An_Unhandled_Case, Cuid, Puid, The_Element);
		if Region_Scan_Internal.Raise_Exception_On_Unhandled_Case then
		    raise Traversal_Error;
		end if;
	end case;
    end loop;

end Scan_Variant_List;
