--| +=========================================================================+
--| |                                                                         |
--| | SCAN.SCAN_SUBTYPE_INDICATION (body)                                     |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Scan)
procedure Scan_Subtype_Indication (The_Indication : in Asis.Subtype_Indication; 
				   The_Context : in out Context) is

    Cuid : constant String := "Scan.Scan_Subtype_Indication";
    Puid : constant String := "Scan_Subtype_Indication";

    package Error renames Scan.Error_Handling_Support;
    package Trace renames Scan.Trace_Support;

begin

    declare
	Constraint : Asis.Constraint := 
	   Asis_Td.Subtype_Constraint (The_Indication);
	Type_Mark : Asis.Expression := Asis_Td.Type_Mark (The_Indication);
    begin

	if Trace.On then
	    Trace.Log (The_Indication);
	    Trace.Add_Level (1 + Scan.One_If_Present (Constraint));
	end if;

	Scan.Scan_Expression (Type_Mark, The_Context);

	if not Asis_E.Is_Nil (Constraint) then
	    Scan.Scan_Constraint (Constraint, The_Context);
	end if;

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Indication);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Indication);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Indication);
	raise;

end Scan_Subtype_Indication;
