--| +=========================================================================+
--| |                                                                         |
--| | SCAN.SCAN_USE_CLAUSE (body)                                             |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Scan)
procedure Scan_Use_Clause (The_Clause : in Asis.Context_Clause; 
			   The_Context : in out Context) is

    Cuid : constant String := "Scan.Scan_Use_Clause";
    Puid : constant String := "Scan_Use_Clause";

    package Error renames Scan.Error_Handling_Support;
    package Trace renames Scan.Trace_Support;

begin

    declare
	Packages : constant Asis.Expression_List := 
	   Asis_X.Named_Packages (The_Clause);
    begin

	if Trace.On then
	    Trace.Log (The_Clause);
	    Trace.Add_Level (Packages'Length);
	end if;

	Scan.Scan_Expression_List (Packages, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Clause);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Clause);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Clause);
	raise;

end Scan_Use_Clause;
