--| +=========================================================================+
--| |                                                                         |
--| | SCAN.SCAN_VARIANT (body)                                                |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Scan)
procedure Scan_Variant (The_Variant : in Asis.Variant; 
			The_Context : in out Context) is

    Cuid : constant String := "Scan.Scan_Variant";
    Puid : constant String := "Scan_Variant";

    package Error renames Scan.Error_Handling_Support;
    package Trace renames Scan.Trace_Support;

begin

    declare
	Choices : constant Asis.Choice_List := 
	   Asis_Td.Variant_Choices (The_Variant);
	Components : constant Asis.Variant_Component_List := 
	   Asis_Td.Variant_Components 
	      (The_Variant, Scan.Include_Record_Type_Definition_Pragmas);
	Implicit_Components : constant Asis.Variant_Component_List := 
	   Asis_Td.Implicit_Variant_Components (The_Variant);
    begin

	if Trace.On then
	    Trace.Log (The_Variant);
	    Trace.Add_Level (Choices'Length + 
			     Scan.One_If_True 
				(Scan.Include_Implicit_Record_Components) * 
			     Implicit_Components'Length + 
			     Components'Length);
	end if;

	Scan.Scan_Choice_List (Choices, The_Context);

	if Scan.Include_Implicit_Record_Components then
	    Scan.Scan_Declaration_List (Implicit_Components, The_Context);
	end if;

	Scan.Scan_Record_Component_List (Components, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Variant);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Variant);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Variant);
	raise;

end Scan_Variant;
